var categoryObject = {
    "uart": {"value": "uart", "title": ["baudrate", "parity", "flowcontrol", "transparent_trigger", "transparent_timeout", "transparent_etx"]},
    "sntp": {"value": "sntp", "title": ["enable", "min_update_interval", "timezone", "server_addresses"]},
    "ssid": {"value": "ssid", "title": ["append_mac", "default_name"]},
    "fota" : {"value": "fota", "title": ["wlan_role"]},
    "transparent_mode" : {"value": "transparent_mode", "title": [    "secure_method", "socket_type", "remote_address", "remote_port", "local_port", "power_save", "skip_date_verify", "disable_cert_store"]}
};

var postObject = {
    "uart": {
        "baudrate": [],
        "parity": [{"value":0, "title": "none"}, {"value":1, "title": "even"}, {"value":2, "title": "odd"}],
        "flowcontrol": [{"value":0, "title": "enable"}, {"value":1, "title": "disable"}],
        "transparent_trigger": [],
        "transparent_timeout": [],
        "transparent_etx": []
    },
    "sntp": {
        "enable": [{"value":0, "title": "enable"}, {"value":1, "title": "disable"}],
        "min_update_interval": [],
        "timezone": [],
        "server_addresses": [{"value":0, "title": "0"}, {"value":1, "title": "1"}, {"value":2, "title": "2"}],
    },
    "ssid": {
        "append_mac": [{"value":0, "title": "true"}, {"value":1, "title": "false"}],
        "default_name": [{"value":0, "title": "enable"}, {"value":1, "title": "disable"}]
    },    
    "fota": {
        "wlan_role": [{"value":0, "title": "station"}, {"value":1, "title": "A.P."}]
    },
    "transparent_mode": {
        "secure_method": [{"value":-1, "title": "None"}, {"value": 0, "title": "SSLV3"}, {"value":1, "title": "TLSV1"}, {"value":2, "title": "TLSV1_1"}, {"value":3, "title": "TLSV1_2"}, {"value":4, "title": "SSLV3_TLSV1_2"}],
        "socket_type": [{"value":0, "title": "SOCKET_TYPE_UDP"}, {"value":1, "title": "SOCKET_TYPE_TCP_SERVER"}, {"value":2, "title": "SOCKET_TYPE_TCP_CLIENT"}],
        "remote_address": [],
        "remote_port": [],
        "local_port": [],
        "power_save": [{"value":0, "title": "disabled"}, {"value":1, "title": "enabled"}],
        "skip_date_verify": [{"value":0, "title": "disabled"}, {"value":1, "title": "enabled"}],
        "disable_cert_store": [{"value":0, "title": "disabled"}, {"value":1, "title": "enabled"}]
    },        
  }

var arr = ["baudrate", "transparent_trigger", "transparent_timeout", "transparent_etx", "min_update_interval", "timezone", "default_name", "remote_address", "remote_port", "local_port"];
var v2arr = ["transparent_etx", "server_addresses"];          

function userLoad()
{
    var categorySel = document.getElementById("category");
    var settingSel = document.getElementById("setting");

    var postCategorySel = document.getElementById("postcategory");
    var postSettingSel = document.getElementById("postsetting");    
    var value1Sel = document.getElementById("value1");
    var value2Sel = document.getElementById("value2");
    //Setting get dropdowns
    for (var x in categoryObject) {
      categorySel.options[categorySel.options.length] = new Option(x, categoryObject[x].value);
    }

    categorySel.onchange = function() {
        //empty Chapters- and Topics- dropdowns
        value2Sel.length = 1;
        settingSel.length = 1;
        var titleList = categoryObject[this.options[this.selectedIndex].text].title;
        for (var y in titleList) {
            settingSel.options[settingSel.options.length] = new Option(titleList[y], titleList[y]);
        }
    }    

    for (var x in postObject) {
        postCategorySel.options[postCategorySel.options.length] = new Option(x, x);
    }

    postCategorySel.onchange = function() {
        //empty Chapters- and Topics- dropdowns
        postSettingSel.length = 1;
        value1Sel.length = 1;
        //display correct values
        for (var y in postObject[this.value]) {
          postSettingSel.options[postSettingSel.options.length] = new Option(y, y);
        }
      }
      postSettingSel.onchange = function() {
        //empty Value1 dropdown
        value1Sel.length = 1;
        //display correct values
        var z = postObject[postCategorySel.value][this.value];

        if (z.length != 0)
        {
            $(".notDD").css('display','none');
            $(".dropDown").css('display','block');            
            for (var i = 0; i < z.length; i++) {
                value1Sel.options[value1Sel.options.length] = new Option(z[i].title, z[i].value);
            }
        }
        else {
            $(".dropDown").css('display','none');            
            $(".notDD").css('display','block');            
        }
        if (jQuery.inArray(this.value, v2arr) !== -1) {
            $(".value2").css('display','block');
        } else {
            $(".value2").css('display','none');            
        }

      }



}

function reqListener () {
    console.log(this.responseText);
}

function getEvent() {
    $(".result").css('display','none');
    $('.result').html("");     
    var xhttp = new XMLHttpRequest();
    xhttp.addEventListener("load", reqListener)

  // Get values from elements on the page:
    var category = $("#category").val();
    var setting = $("#setting").val();

    if (category == "" || setting=="") {
        var responseText= "";
        if (category == "")
            responseText+="Please select category.<br>";
        if (setting == "")
            responseText+="Please select setting.";
        $('.result').html(responseText);             
        $(".result").css('display','block');
        return;
    }

    xhttp.open("GET", "/usersettings?category=" + category + "&setting=" + setting, true);

    xhttp.onreadystatechange = function() {
        if (this.readyState === XMLHttpRequest.DONE) {
            if (this.status === 200) {
                $('.result').html(this.responseText); 
            } else {
                $('.result').html("Error " + this.status + ": " + this.statusText); 
            }
        }
        $(".result").css('display','block');        
    };
    xhttp.send();
}

  function postEvent() {
    $(".result").css('display','none');
    $('.result').html("");       
    var invalid = false;
    var category = $("#postcategory").val();
    var setting = $("#postsetting").val();
    var firstValue = $("#value1").val();
    var value2 = $("#value2").val();
    var error = "Input error:";
    if (jQuery.inArray(setting, arr) !== -1) {
        firstValue = $("#value1Text").val();
    }
    if (invalid) 
    {
        $('.result').html(error); 
        $(".result").css('display','block');
    } 
    else
    {
        var params = 'category=' + category + '&setting=' + setting + '&value1=' + firstValue + '&value2=';
        if (jQuery.inArray(setting, v2arr) !== -1)
            params += value2;

        var xhttp = new XMLHttpRequest();
        xhttp.addEventListener("load", reqListener)
        //Send the proper header information along with the request
        xhttp.open("POST", "/usersettings?" + params, true);
        xhttp.setRequestHeader("Content-Type", "none");    
    
        xhttp.onreadystatechange = function() {
            if (this.readyState === XMLHttpRequest.DONE) {
                if (this.status === 200 || this.status === 204) {
                    if (this.responseText != "") {
                        $('.result').html(this.responseText);
                    } else {
                        $('.result').html("Success: " + this.status + ": " + this.statusText);
                    } 
                } else {
                    $('.result').html("Error " + this.status + ": " + this.statusText); 
                }
            }
            $(".result").css('display','block');       
        };        
       
        xhttp.send();
    }
}