var typeObject = {
    "Unused": { "value": 0, "title": [] },
    "Input": { "value": 1, "title": ["No pull", "Pull down", "Pull up"] },
    "Output": { "value": 2, "title": ["Low", "High"] },
    "PWM": { "value": 3, "title": [] }
};

function gpioLoad() {
    var typeSel = document.getElementById("type");
    var value1Sel = document.getElementById("value1");
    var value2Sel = document.getElementById("value2");
    for (var x in typeObject) {
        typeSel.options[typeSel.options.length] = new Option(x, typeObject[x].value);
    }
    typeSel.onchange = function () {
        //empty Chapters- and Topics- dropdowns
        value2Sel.length = 1;
        value1Sel.length = 1;
        var titleList = typeObject[this.options[this.selectedIndex].text].title;
        if (titleList.length != 0) {
            $(".pwm").css('display', 'none');
            $(".unused").css('display', 'none');
            $(".notpwm").css('display', 'block');
            for (var y in titleList) {
                value1Sel.options[value1Sel.options.length] = new Option(titleList[y], y);
            }
        }
        else {
            $(".notpwm").css('display', 'none');
            if (this.options[this.selectedIndex].text == "PWM") {
                $(".pwm").css('display', 'block');
            } else {
                $(".pwm").css('display', 'none');
                $(".unused").css('display', 'block');
            }
        }
    }

    //     value1Sel.onchange = function() {
    //       //empty Chapters dropdown
    //       value2Sel.length = 1;
    //       //display correct values
    //       var z = typeObject[typeSel.value][this.value];
    //       for (var i = 0; i < z.length; i++) {
    //         value2Sel.options[value2Sel.options.length] = new Option(z[i], z[i]);
    //       }
    //     }
}

function reqListener() {
    console.log(this.responseText);
}

function getEvent() {
    $(".result").css('display', 'none');
    $('.result').html("");
    var xhttp = new XMLHttpRequest();
    xhttp.addEventListener("load", reqListener)

    // Get values from elements on the page:
    var gpioId = $("#gpioID").val();
    var gpioDefault = $("#gpioDefault").val();

    xhttp.open("GET", "/gpio?id=" + gpioId + "&default=" + gpioDefault, true);

    xhttp.onreadystatechange = function () {
        if (this.readyState === XMLHttpRequest.DONE) {
            if (this.status === 200) {
                $('.result').html(this.responseText);
            } else {
                $('.result').html("Error " + this.status + ": " + this.statusText);
            }
        }
        $(".result").css('display', 'block');
    };
    xhttp.send();
}

function postEvent() {
    $(".result").css('display','none');
    $('.result').html("");     
    var invalid = false;
    var gpioId = $("#gpioIDPost").val();
    var gpioType = $("#type").val();
    var gpioSave = $("#save").prop("checked") ? 1 : 0;
    var firstValue = $("#value1").val();
    var value2 = $("#value2").val();
    var error = "Input error:";
    if (gpioType == 3) {
        firstValue = $("#value1Text").val();
        if (isNaN(firstValue)) {
            invalid = true;
            error += "<br>Value1 is not a number!"
        }
        else {
            if (firstValue < 1 || firstValue > 200) {
                invalid = true;
                error += "<br>Value1 is not between 1ms and 200ms."
            }
        }
        if (isNaN(value2)) {
            invalid = true;
            error += "<br>Value2 is not a number!"
        }
        else {
            if (value2 < 0 || value2 > 100) {
                invalid = true;
                error += "<br>Value2 is not between 0 and 100%."
            }
        }
    }
    if (invalid) {
        $('.result').html(error);
        $(".result").css('display', 'block');
    }
    else {
        var params = 'id=' + gpioId + '&type=' + gpioType + '&save=' + gpioSave + '&value1=' + firstValue;
        if (gpioType == 3)
            params += '&value2=' + value2;

        var xhttp = new XMLHttpRequest();
        xhttp.addEventListener("load", reqListener)
        //Send the proper header information along with the request
        xhttp.open("POST", "/gpio?" + params, true);
        xhttp.setRequestHeader("Content-Type", "none");

        xhttp.onreadystatechange = function () {
            if (this.readyState === XMLHttpRequest.DONE) {
                if (this.status === 200 || this.status === 204) {
                    if (this.responseText != "") {
                        $('.result').html(this.responseText);
                    } else {
                        $('.result').html("Success: " + this.status + ": " + this.statusText);
                    }
                } else {
                    $('.result').html("Error " + this.status + ": " + this.statusText);
                }
            }
            $(".result").css('display','block');    
        }


    };

    xhttp.send();
}